/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org2.eclipse.php.debug.core.debugger.IDebugHandler;

public class DebugHandlersRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugHandlers";
    private static final String HANDLER_TAG = "handler";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String REMOTE_DEBUGGER_ATTRIBUTE = "debugger";
    private Dictionary actions = new Hashtable();
    private Dictionary debuggers = new Hashtable();
    private static DebugHandlersRegistry instance = null;

    private DebugHandlersRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.php.debug.epl", EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (HANDLER_TAG.equals(element.getName())) {
                this.actions.put(element.getAttribute(ID_ATTRIBUTE), new DebugHandlerFactory(element));
                String debugger = element.getAttribute(REMOTE_DEBUGGER_ATTRIBUTE);
                if (debugger != null) {
                    this.debuggers.put(element.getAttribute(ID_ATTRIBUTE), debugger);
                }
            }
            ++i;
        }
    }

    private static DebugHandlersRegistry getInstance() {
        if (instance == null) {
            instance = new DebugHandlersRegistry();
        }
        return instance;
    }

    private Dictionary getHandlers() {
        return this.actions;
    }

    public static IDebugHandler getHandler(String id) throws Exception {
        return ((DebugHandlerFactory)DebugHandlersRegistry.getInstance().getHandlers().get(id)).createHandler();
    }

    public static String getRemoteDebuggerID(String debugHandlerID) {
        return (String)DebugHandlersRegistry.getInstance().debuggers.get(debugHandlerID);
    }

    class DebugHandlerFactory {
        IDebugHandler handler;
        IConfigurationElement element;

        public DebugHandlerFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IDebugHandler createHandler() {
            Platform.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org2.eclipse.php.internal.debug.core.phpDebugHandlers"){

                public void run() throws Exception {
                    DebugHandlerFactory.this.handler = (IDebugHandler)DebugHandlerFactory.this.element.createExecutableExtension(DebugHandlersRegistry.CLASS_ATTRIBUTE);
                }
            });
            return this.handler;
        }
    }
}

